/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingPublicCrafter;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.JobBaker;
import com.minecolonies.coremod.util.FurnaceRecipes;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingBaker
extends AbstractBuildingFurnaceUser
implements IBuildingPublicCrafter {
    private static final String BAKER = "baker";
    private static final int BAKER_HUT_MAX_LEVEL = 5;

    public BuildingBaker(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BAKER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    protected boolean keepFood() {
        return false;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobBaker(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return BAKER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Knowledge;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Dexterity;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.bakery;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151015_O) {
            return false;
        }
        return super.canEat(stack);
    }

    @Override
    public Skill getCraftSpeedSkill() {
        return this.getSecondarySkill();
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        private static final int RECIPE_INPUT_HOLD = 128;

        @Override
        @Nullable
        public IJob<?> getCraftingJob() {
            return this.getMainBuildingJob().orElseGet(() -> new JobBaker(null));
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingBaker.BAKER);
            return isRecipeAllowed.orElse(false);
        }

        @Override
        public boolean canLearnCraftingRecipes() {
            if (this.building == null) {
                return true;
            }
            return this.building.getBuildingLevel() >= 3;
        }

        @Override
        public boolean addRecipe(IToken<?> token) {
            boolean recipeAdded = super.addRecipe(token);
            if (recipeAdded) {
                IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
                ItemStack smeltResult = FurnaceRecipes.getInstance().getSmeltingResult(storage.getPrimaryOutput());
                if (smeltResult != null) {
                    IRecipeStorage smeltingRecipe = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{ImmutableList.of((Object)new ItemStorage(storage.getPrimaryOutput().func_77946_l())), 1, smeltResult, Blocks.field_150460_al});
                    this.addRecipeToList(IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(smeltingRecipe), false);
                }
            }
            return recipeAdded;
        }

        @Override
        public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
            Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> map = super.getRequiredItemsAndAmount();
            for (IToken<?> token : this.getRecipes()) {
                IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
                for (ItemStorage itemStorage : storage.getCleanedInput()) {
                    ItemStack stack = itemStorage.getItemStack();
                    map.put(arg_0 -> ((ItemStack)stack).func_77969_a(arg_0), (Tuple<Integer, Boolean>)new Tuple((Object)128, (Object)false));
                }
            }
            return map;
        }
    }

    public static class View
    extends AbstractBuildingWorkerView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, BuildingBaker.BAKER);
        }
    }
}

